﻿#STUDY 3 
#Note: Upon reanalyzing the data for Study 3 using R to create the R code, we noticed there are minor differences compared to the results in the paper (where the data was previously analyzed with Minitab and SPSS, without documentation). We are in the process of reverse engineering the analyses (starting from the results in the paper and working backwards, testing variations) to determine the source of the differences and reproduce the exact results in the paper. Thank you for your understanding!


#clear the workspace
rm(list = ls())


#install.packages('epiDisplay')
library(epiDisplay)
#install.packages('tidyr')
library(tidyr)
#install.packages('ggplot2')
library(ggplot2)
#install.packages('dplyr')
library(dplyr)
#install.packages('aod')
library(aod)




#set the working directory
setwd("~/Desktop/R")


#adhere to the sum-to-zero convention for effect weights
options(contrasts=c("contr.sum","contr.poly"))


# read the data from a csv file
carbon3<-read.csv("carbon3.csv")


# show the variable names and the first few rows of values
head(carbon3)


#calculate N (sample size)
length(na.omit(carbon3$serial))
________________


#calculate the percentage of Republicans following order in their unnatural order


#Count the number of Republican participants in their unnatural order (non-blank cells)
Repub_in_unnatural <- nrow(carbon3[!is.na(carbon3$NaturalElke) & !is.na(carbon3$Repub1) & carbon3$NaturalElke == 0 & carbon3$Repub1 == 1, ])
Repub_in_unnatural


# Count the number of Republican participants who followed directions in their unnatural order (non-blank cells)
followed_Repub_in_unnatural <- nrow(carbon3[!is.na(carbon3$NaturalElke) & !is.na(carbon3$Repub1) & !is.na(carbon3$followeddir1) & carbon3$NaturalElke == 0 & carbon3$Repub1 == 1 & carbon3$followeddir1 == 1, ])
followed_Repub_in_unnatural


# Calculate % of Republicans who followed the task instruction sequence (unnatural)
percentage_followed <- (followed_Repub_in_unnatural / Repub_in_unnatural) * 100
percentage_followed
________________


# Calculate the percentage of Republicans following order in their natural order


# Count the number of Republican participants in their natural order and tax frame (non-blank cells)
Repub_in_natural <- nrow(carbon3[!is.na(carbon3$NaturalElke) & !is.na(carbon3$Repub1) & carbon3$NaturalElke == 1 & carbon3$Repub1 == 1 & carbon3$tax0off1 == 0, ])
Repub_in_natural


# Count the number of Republican participants who followed directions in their natural order (non-blank cells)
followed_Repub_in_natural <- nrow(carbon3[!is.na(carbon3$NaturalElke) & !is.na(carbon3$Repub1) & carbon3$NaturalElke == 1 & carbon3$Repub1 == 1 & carbon3$tax0off1 == 0 & carbon3$followeddir1 == 1, ])
followed_Repub_in_natural


# Calculate % of Republicans who followed the task instruction sequence (natural)
percentage_followed_1 <- (followed_Repub_in_natural / Repub_in_natural) * 100
percentage_followed_1


________________


#based on LinMD_Tax column(0,1,-1)
#logistic regression for choosing more expensive option based on political affiliation


#filter data in tax frame for those participants who followed instructions and ignore NULL data
train_tax<-na.omit(filter(carbon3, carbon3$tax0off1==0 & carbon3$followeddir1==1))


#logistic regression in tax condition
model_tax<-glm(formula = product_offtax ~ LinMD_Tax, family = binomial, data = train_tax)


# Extract beta coefficients
coefficients_tax <- coef(model_tax)
# Extract standard errors
se_tax <- summary(model_tax)$coefficients[, "Std. Error"]
# Extract p-values
p_values_tax <- summary(model_tax)$coefficients[, "Pr(>|z|)"]
coefficients_tax
se_tax
p_values_tax
________________


#based on LinMD_Off column (0,1,-1)
#logistic regression for choosing more expensive option based on political affiliation
#filter data in offset frame for those participants who followed instructions and ignore NULL data
train_off<-na.omit(filter(carbon3, carbon3$tax0off1==1 & carbon3$followeddir1==1))


#logistic regression in offset condition
model_off<-glm(formula = product_offtax ~ LinMD_Off, family = binomial, data = train_off)


# Extract beta coefficients
coefficients_off <- coef(model_off)
# Extract standard errors
se_off <- summary(model_off)$coefficients[, "Std. Error"]
# Extract p-values
p_values_off <- summary(model_off)$coefficients[, "Pr(>|z|)"]
coefficients_off
se_off
p_values_off
________________


#logistic regression (one-tailed test) including participants who did not follow direction
#filter data in tax frame and ignore Null values
train_onetail<-na.omit(filter(carbon3, carbon3$tax0off1==0))


# Fit logistic regression model
tax_onetail <- glm(formula = product_offtax ~ LinMD_tax, family = binomial, data = train_onetail)


# Extract beta coefficients
coefficients_off_onetail <- coef(tax_onetail)


# Extract standard errors
se_off_onetail <- summary(tax_onetail)$coefficients[, "Std. Error"]


# Extract p-values
p_values_off_onetail <- summary(tax_onetail)$coefficients[, "Pr(>|z|)"]


coefficients_off_onetail
se_off_onetail
p_values_off_onetail